package com.biz.crm.dms.business.reconciliation.sdk.enums;

/**
 * 对账函往来记录操作类型
 * Created by Bao Hongbin on 2021-12-21 17:24.
 */
public enum ReconciliationLetterOperateType {
  PUSH("push","push", "确认推送对账单", 1),
  QUESTION("question","question", "提出疑问", 2),
  ANSWER("answer","answer", "厂商答复", 3),
  UPDATE("update","update", "更新对账单", 4),
  CONFIRM("confirm","confirm", "确认对账单", 5);

  /**
   * key
   */
  private String key;
  /**
   * 编码
   */
  private String dictCode;
  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;

  ReconciliationLetterOperateType(String key, String dictCode, String value, Integer order) {
    this.key = key;
    this.dictCode = dictCode;
    this.value = value;
    this.order = order;
  }

  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ReconciliationLetterOperateType codeToEnum(String dictCode) {
    ReconciliationLetterOperateType result = null;
    for (ReconciliationLetterOperateType reconciliationLetterOperateType : ReconciliationLetterOperateType.values()) {
      if (reconciliationLetterOperateType.dictCode.equals(dictCode)) {
        result = reconciliationLetterOperateType;
      }
    }
    return result;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public Integer getOrder() {
    return order;
  }

  public String getValue() {
    return value;
  }
}
