package com.biz.crm.dms.business.reconciliation.sdk.enums;

/**
 * 对账函状态
 * Created by Bao Hongbin on 2021-12-21 17:24.
 */
public enum ReconciliationLetterStatus {
  WAIT_PUSH("wait_push","wait_push", "待推送", 1),
  WAIT_FINANCIAL_REVIEW("wait_financial_review","wait_financial_review", "待财务复核", 2),
  WAIT_CUSTOMER_CONFIRMATION("wait_customer_confirmation","wait_customer_confirmation", "待客户确认", 3),
  COMPLETED("completed","completed", "已完成", 4);

  /**
   * key
   */
  private String key;
  /**
   * 编码
   */
  private String dictCode;
  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;

  ReconciliationLetterStatus(String key, String dictCode, String value, Integer order) {
    this.key = key;
    this.dictCode = dictCode;
    this.value = value;
    this.order = order;
  }

  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ReconciliationLetterStatus codeToEnum(String dictCode) {
    ReconciliationLetterStatus result = null;
    for (ReconciliationLetterStatus reconciliationLetterOperateType : ReconciliationLetterStatus.values()) {
      if (reconciliationLetterOperateType.dictCode.equals(dictCode)) {
        result = reconciliationLetterOperateType;
      }
    }
    return result;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public Integer getOrder() {
    return order;
  }

  public String getValue() {
    return value;
  }
}
