package com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement;

import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.AbstractReconciliationElementDataVo;

import java.util.Date;

/**
 * @program: crm-dms
 * @description: 对账要素注册器(需要添加对账要素必须实现此接口)
 * @author: Bao Hongbin
 * @create: 2021-12-15 11:06
 **/
public interface ReconciliationElementRegister<T extends AbstractReconciliationElementDataVo> {

  /**
   * 获取对账要素信息
   *
   * @return 对账要素基本信息
   */
  ReconciliationElementInfoVo getReconciliationElementInfo();

  /**
   * 对账函编码查询查询对账要素内容
   *
   * @param letterCode 对账函编码
   * @return 对账要素内容
   */
  T getByLetterCode(String letterCode,String customerCode);

  /**
   * 生成对账函对应对账要素内容
   *
   * @param letterCode           对账函编码
   * @param customerCode         客户编码
   * @param calculationStartTime 计算开始时间
   * @param calculationEndTime   计算结束时间
   * @return 对账要素内容
   */
  T create(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime);

  /**
   * 更新对账函对应对账要素内容
   *
   * @param letterCode 对账函编码
   * @return 对账要素内容
   */
  T update(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime);

}
