package com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate;

import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationCustomerInfoVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationTemplateRangeInfoVo;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账规则生效范围注册器(需要添加对账规则生效范围必须实现此接口)
 * @author: Bao Hongbin
 * @create: 2021-12-15 11:06
 **/
public interface ReconciliationTemplateRangeRegister {

  /**
   * 获取对账规则生效范围信息
   *
   * @return 获取对账规则生效范围信息
   */
  ReconciliationTemplateRangeInfoVo getReconciliationRangeInfo();

  /**
   * 根据生效范围数据编码集合，查询客户简要信息
   *
   * @param dataCodes
   * @return
   */
  List<ReconciliationCustomerInfoVo> getCustomerInfoByDataCodes(List<String> dataCodes);


}
