package com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata;
/**
 * Created by Bao Hongbin on 2021-12-15 11:06.
 */

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @program: crm-dms
 * @description: 对账要素数据抽象vo
 * @author: Bao Hongbin
 * @create: 2021-12-15 11:06
 **/
@Data
@ApiModel(value = "对账要素数据抽象vo")
public abstract class AbstractReconciliationElementDataVo {
  /**
   * 要素编码
   */
  @ApiModelProperty("要素编码")
  private String elementCode;
  /**
   * 对账函编码
   */
  @ApiModelProperty("对账函编码")
  private String letterCode;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationStartTime;
  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationEndTime;
}
