package com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata;
/**
 * Created by Bao Hongbin on 2021-12-17 14:58.
 */

import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionDetailsType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @program: crm-dms
 * @description: 客户往来记录明细数据vo
 * @author: Bao Hongbin
 * @create: 2021-12-17 14:58
 **/
@Data
@ApiModel(value = "客户往来记录明细数据vo")
public class CustomerTransactionDetailsDataVo {
  /**
   * 往来明细类型
   */
  @ApiModelProperty("往来明细类型")
  private CustomerTransactionDetailsType transactionDetailsType;

  /**
   * 往来明细类型str
   */
  @ApiModelProperty("往来明细类型str")
  private String transactionDetailsTypeStr;

  /**
   * 现金金额
   */
  @ApiModelProperty("现金金额")
  private BigDecimal cashAmount;

  /**
   * 授信金额
   */
  @ApiModelProperty("授信金额")
  private BigDecimal creditAmount;

  /**
   * 折扣金额
   */
  @ApiModelProperty("折扣金额")
  private BigDecimal discountAmount;

  /**
   * 货补金额
   */
  @ApiModelProperty("货补金额")
  private BigDecimal goodsSubsidyAmount;

  /**
   * 合计金额
   */
  @ApiModelProperty("合计金额")
  private BigDecimal totalAmount;
}
