package com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter;
/**
 * Created by Bao Hongbin on 2021-12-21 20:50.
 */

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterStatus;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.AbstractReconciliationElementDataVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账函vo
 * @author: Bao Hongbin
 * @create: 2021-12-21 20:50
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationLetterVo", description = "对账函vo")
public class ReconciliationLetterVo extends TenantFlagOpVo {

  /**
   * 对账函编码
   */
  @ApiModelProperty("对账函编码")
  private String reconciliationLetterCode;

  /**
   * 对账函状态
   */
  @ApiModelProperty("对账函状态")
  private ReconciliationLetterStatus reconciliationLetterStatus;

  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  private String reconciliationTemplateCode;

  /**
   * 对账规则（模板）名称
   */
  @ApiModelProperty("对账规则（模板）名称")
  private String reconciliationTemplateName;

  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationStartTime;

  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationEndTime;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户确认时间
   */
  @ApiModelProperty("客户确认时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;


  /**
   * 往来记录
   */
  @ApiModelProperty("往来记录")
  private List<ReconciliationContactRecordVo> contactRecordVoList;

  /**
   * 对账要素
   */
  @ApiModelProperty("对账要素")
  private List<AbstractReconciliationElementDataVo> elementDataVos;

  /**
   * 现金期末余额
   */
  @ApiModelProperty("现金期末余额")
  private BigDecimal cashAmount;

  /**
   * 授信期末余额
   */
  @ApiModelProperty("授信期末余额")
  private BigDecimal creditAmount;

  /**
   * 折扣期末余额
   */
  @ApiModelProperty("折扣期末余额")
  private BigDecimal discountAmount;

  /**
   * 货补期末余额
   */
  @ApiModelProperty("货补期末余额")
  private BigDecimal goodsSubsidyAmount;

  /**
   * 经销商意见反馈
   */
  @ApiModelProperty("经销商意见反馈")
  private String opinions;
}
