package com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-20 14:15.
 */

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @program: crm-dms
 * @description: 对账规则要素vo
 * @author: Bao Hongbin
 * @create: 2021-12-20 14:15
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationTemplateElementVo", description = "对账规则要素vo")
public class ReconciliationTemplateElementVo extends TenantVo {
  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  private String reconciliationTemplateCode;

  /**
   * 要素编码
   */
  @ApiModelProperty("要素编码")
  private String elementCode;

  /**
   * 要素名称
   */
  @ApiModelProperty("要素名称")
  private String elementName;

  /**
   * 对账规则中各要素的排序
   */
  @ApiModelProperty("对账规则中各要素的排序")
  private Integer sort;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remarks;
}
