package com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-20 14:06.
 */

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.dms.business.reconciliation.sdk.enums.GenerationCycleType;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账规则（模板）vo
 * @author: Bao Hongbin
 * @create: 2021-12-20 14:06
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationTemplateVo", description = "对账规则（模板）vo")
public class ReconciliationTemplateVo extends TenantFlagOpVo {

  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  private String reconciliationTemplateCode;

  /**
   * 对账规则（模板）名称
   */
  @ApiModelProperty("对账规则（模板）名称")
  private String reconciliationTemplateName;

  /**
   * 有效开始时间
   */
  @ApiModelProperty("有效开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date validityStartTime;

  /**
   * 有效结束时间
   */
  @ApiModelProperty("有效结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date validityEndTime;

  /**
   * 生成周期类型
   */
  @ApiModelProperty("生成周期类型")
  private GenerationCycleType generationCycleType;

  /**
   * 生成时间
   * 对账函计算期结束后的第几天生成
   */
  @ApiModelProperty("生成时间")
  private Integer generationTime;

  /**
   * 对账规则计算时间数据
   */
  @ApiModelProperty("对账规则计算时间数据")
  private List<ReconciliationLetterCalculationTimeVo> calculationTimes;

  /**
   * 对账规则要素数据
   */
  @ApiModelProperty("对账规则要素数据")
  private List<ReconciliationTemplateElementVo> elements;


  /**
   * 对账规则生效范围数据
   */
  @ApiModelProperty("对账规则生效范围数据")
  private List<ReconciliationTemplateRangeVo> ranges;
}
