package com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-20 14:32.
 */

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @program: crm-dms
 * @description: 对账规则生成时间dto
 * @author: Bao Hongbin
 * @create: 2021-12-20 14:32
 **/
@Data
@ApiModel("对账规则计算时间创建dto")
public class ReconciliationLetterCalculationTimeCreateDto {
  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationStartTime;

  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationEndTime;

  /**
   * 计算时间
   */
  @ApiModelProperty("计算时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationTime;
}
