package com.biz.crm.dms.business.reconciliation.sdk.enums;

/**
 * 对账要素-客户往来记录数据类型
 * Created by Bao Hongbin on 2021-12-17 09:51.
 */
public enum CustomerTransactionDetailsType {

  OPENING_BALANCE("opening_balance","opening_balance", "期初余额", 1),
  KEEP_BOOKS("keep_books", "keep_books", "上账", 2),
  USED("used", "used", "使用", 3),
  CLOSING_BALANCE("closing_balance","closing_balance", "期末余额", 4);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;

  CustomerTransactionDetailsType(String key, String dictCode, String value, Integer order) {
    this.key = key;
    this.dictCode = dictCode;
    this.value = value;
    this.order = order;
  }

  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static CustomerTransactionDetailsType codeToEnum(String dictCode) {
    CustomerTransactionDetailsType result = null;
    for (CustomerTransactionDetailsType customerTransactionDetailsType : CustomerTransactionDetailsType.values()) {
      if (customerTransactionDetailsType.dictCode.equals(dictCode)) {
        result = customerTransactionDetailsType;
      }
    }
    return result;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public Integer getOrder() {
    return order;
  }

  public String getValue() {
    return value;
  }
}
