package com.biz.crm.dms.business.reconciliation.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 资金类型
 * @author: rentao
 * @date: 2022/1/20 10:24
 */
public enum CustomerTransactionPoolType {

  CAPITAL("capital", "capital", "现金费用池", "1"),
  CREDIT("credit", "credit", "授信费用池", "2"),
  DISCOUNT("discount", "discount", "折扣费用池", "3"),
  REPLENISHMENT("replenishment", "replenishment", "货补费用池", "4");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CustomerTransactionPoolType(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static CustomerTransactionPoolType getByKey(String key) {
    return Arrays.stream(CustomerTransactionPoolType.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
