package com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter;
/**
 * Created by Bao Hongbin on 2021-12-23 19:18.
 */

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterOperateType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账往来记录vo
 * @author: Bao Hongbin
 * @create: 2021-12-23 19:18
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationContactRecordVo", description = "对账往来记录vo")
public class ReconciliationContactRecordVo extends TenantOpVo {
  /**
   * 对账函编码
   */
  @ApiModelProperty("对账函编码")
  private String reconciliationLetterCode;

  /**
   * 岗位编码
   */
  @ApiModelProperty("岗位编码")
  private String postCode;
  /**
   * 岗位名称
   */
  @ApiModelProperty("岗位名称")
  private String postName;
  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 操作动作类型
   */
  @ApiModelProperty("操作动作类型")
  private ReconciliationLetterOperateType reconciliationLetterOperateType;

  /**
   * 沟通内容
   */
  @ApiModelProperty("沟通内容")
  private String content;

  /**
   * 附件
   */
  @ApiModelProperty("附件")
  private List<ReconciliationContactRecordFileVo> contactRecordFileVos;
}
