package com.biz.crm.dms.business.sale.goal.local.starter.config;

import com.biz.crm.dms.business.sale.goal.local.service.notifier.SaleGoalContractEventListenerImpl;
import com.biz.crm.dms.business.sale.goal.local.service.register.SaleGoalRoutineElementRegisterImpl;
import com.biz.crm.dms.business.sale.goal.local.service.register.SaleGoalSeriesElementRegisterImpl;
import com.biz.crm.dms.business.sale.goal.local.service.register.SaleGoalSingleElementRegisterImpl;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @description: 销量目标模块配置
 * @author: rentao
 * @date: 2021/11/30 10:22
 */
@Configuration
@EntityScan(basePackages = "com.biz.crm.dms.business.salegoal.local.entity")
@ComponentScan(basePackages = {"com.biz.crm.dms.business.sale.goal"})
public class SaleGoalLocalConfig {

  /**
   *
   * 标品合同变更通知销量目标 依赖注入
   * @author rentao
   * @date
   */
  @Bean
  public SaleGoalContractEventListenerImpl getSaleGoalContractEventListenerImpl() {
    return new SaleGoalContractEventListenerImpl();
  }

  /**
   *
   * 常规销量目标 依赖注入
   * @author rentao
   * @date
   */
  @Bean
  public SaleGoalRoutineElementRegisterImpl getSaleGoalRoutineElementRegisterImpl() {
    return new SaleGoalRoutineElementRegisterImpl();
  }

  /**
   *
   * 系列销量目标 依赖注入
   * @author rentao
   * @date
   */
  @Bean
  public SaleGoalSeriesElementRegisterImpl getSaleGoalSeriesElementRegisterImpl() {
    return new SaleGoalSeriesElementRegisterImpl();
  }

  /**
   *
   * 单品销量目标 依赖注入
   * @author rentao
   * @date
   */
  @Bean
  public SaleGoalSingleElementRegisterImpl getSaleGoalSingleElementRegisterImpl() {
    return new SaleGoalSingleElementRegisterImpl();
  }
}
