package com.biz.crm.dms.business.sale.goal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.sale.goal.dto.SaleGoalDto;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoal;
import com.biz.crm.dms.business.sale.goal.local.service.SaleGoalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @description: 销量目标
 * @author: rentao
 * @date: 2021/11/30 11:07
 */
@Slf4j
@RestController
@RequestMapping("/v1/salegoal/salegoal")
@Api(tags = "销量目标: SaleGoal: 销量目标管理")
public class SaleGoalController {

  @Autowired(required = false) private SaleGoalService saleGoalService;

  /**
   * 销量目标分页查询
   *
   * @param pageable 分页信息
   * @param dto 参数Dto
   * @return 公告分页数据
   */
  @ApiOperation(value = "销量目标分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<SaleGoal>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "SaleGoalDto", value = "分页Dto") SaleGoalDto dto) {
    try {
      return Result.ok(this.saleGoalService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增销量目标信息
   *
   * @param saleGoalDtos 参数dto
   * @return 新增销量目标数据
   */
  @ApiOperation(value = "新增销量目标")
  @PostMapping("")
  public Result create(@RequestBody List<SaleGoalDto> saleGoalDtos) {
    try {
      return Result.ok(this.saleGoalService.createBatch(saleGoalDtos));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新销量目标信息
   *
   * @param dto 参数dto
   * @return 更新后销量目标数据
   */
  @ApiOperation(value = "更新销量目标信息")
  @PatchMapping("")
  public Result update(@RequestBody SaleGoalDto dto) {
    try {
      return Result.ok(this.saleGoalService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除销量目标
   *
   * @param ids 销量目标id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.saleGoalService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
