package com.biz.crm.dms.business.sale.goal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.sale.goal.service.SaleGoalVoService;
import com.biz.crm.dms.business.sale.goal.vo.SaleGoalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 销量目标vo
 * @author: rentao
 * @date: 2021/11/30 11:25
 */
@Slf4j
@RestController
@RequestMapping("/v1/salegoal/salegoal")
@Api(tags = "销量目标: SaleGoalVo: 销量目标管理")
public class SaleGoalVoController {

  @Autowired(required = false) private SaleGoalVoService saleGoalVoService;

  /**
   * 通过ID获取销量目标信息
   *
   * @param id 销量目标ID
   * @return 操作结果
   */
  @ApiOperation(value = "通过ID获取销量目标信息")
  @GetMapping("/findById")
  public Result<SaleGoalVo> findById(
      @RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID")
          String id) {
    try {
      return Result.ok(this.saleGoalVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
