package com.biz.crm.dms.business.sale.goal.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Index;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @description: 销量目标
 * @author: rentao
 * @date: 2021/11/30 10:57
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SaleGoalEntity", description = "销量目标实体类")
@Entity
@TableName("dms_sale_goal")
@Table(name = "dms_sale_goal",
    indexes = {@Index(columnList = "tenant_code,only_key,del_flag", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_goal", comment = "销量目标表")
public class SaleGoal extends TenantFlagOpEntity {
  private static final long serialVersionUID = 5869205201384235070L;

  /**
   * 对象维度，1 客户、2 组织、3 终端
   *
   */
  @ApiModelProperty(name = "objectType", value = "对象维度，1 客户、2 组织、3 终端", required = true)
  @Column(name = "object_type", nullable = false, columnDefinition = "smallint COMMENT '对象维度，1 客户、2 组织、3 终端'")
  private Integer objectType;

  /**
   * 目标类型 0 常规，1 单品，2 系列
   *
   */
  @ApiModelProperty(name = "SaleGoalType", value = "目标类型 0 常规，1 单品，2 系列", required = true)
  @Column(name = "sale_goal_type", nullable = false, columnDefinition = "smallint COMMENT '目标类型 0 常规，1 单品，2 系列'")
  private Integer saleGoalType;

  /**
   * 任务类型，1 年目标、2 季度目标、3 月度目标
   *
   */
  @ApiModelProperty(name = "taskType", value = "任务类型，1 年目标、2 季度目标、3 月度目标", required = true)
  @Column(name = "task_type", nullable = false, columnDefinition = "smallint COMMENT '任务类型，1 年目标、2 季度目标、3 月度目标'")
  private Integer taskType;

  /**
   * 销量目标名称
   */
  @ApiModelProperty(name = "saleGoalName", value = "销量目标名称", required = true)
  @Column(name = "sale_goal_name", length = 128, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '客户编码'")
  private String saleGoalName;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  @Column(name = "cus_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户编码'")
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  @Column(name = "cus_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户名称'")
  private String cusName;

  /**
   * 客户所属组织编码
   */
  @ApiModelProperty(name = "cusOrgCode", value = "客户所属组织编码", required = true)
  @Column(name = "cus_org_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户所属组织编码'")
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty(name = "cusOrgName", value = "客户所属组织名称", required = true)
  @Column(name = "cus_org_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户所属组织名称'")
  private String cusOrgName;

  /**
   * 客户所属渠道编码
   */
  @ApiModelProperty(name = "cusChannelCode", value = "客户所属渠道编码", required = true)
  @Column(name = "cus_channel_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户所属渠道编码'")
  private String cusChannelCode;

  /**
   * 客户所属渠道名称
   */
  @ApiModelProperty(name = "cusChannelName", value = "客户所属渠道编码", required = true)
  @Column(name = "cus_channel_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户所属渠道名称'")
  private String cusChannelName;


  /**
   * 销售区域编码
   */
  @ApiModelProperty(name = "salesAreaCode", value = "销售区域编码", required = true)
  @Column(name = "sales_area_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售区域编码'")
  private String salesAreaCode;

  /**
   * 销售区域名称
   */
  @ApiModelProperty(name = "salesAreaName", value = "销售区域名称", required = true)
  @Column(name = "sales_area_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售区域名称'")
  private String salesAreaName;


  /**
   * 年度
   */
  @ApiModelProperty(name = "targetYear", value = "年度", required = true)
  @Column(name = "target_year", nullable = false, columnDefinition = "smallint COMMENT '年度'")
  private Integer targetYear;


  /**
   * 年度类型 1 自然年 2 企业财年
   */
  @ApiModelProperty(name = "targetYearType", value = "年度类型 1 自然年 2 企业财年", required = true)
  @Column(name = "target_year_type", nullable = false, columnDefinition = "smallint COMMENT '年度类型'")
  private Integer targetYearType;

  /**
   *单位编码
   */
  @ApiModelProperty(name = "unitCode", value = "单位编码", required = true)
  @Column(name = "unit_code",length = 128, columnDefinition = "VARCHAR(128)  COMMENT '单位编码'")
  private String unitCode;

  /**
   * 组织编码（对象维度为组织时，选择）
   */
  @ApiModelProperty(name = "orgCode", value = "组织编码(对象维度为组织时，选择)", required = true)
  @Column(name = "org_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '组织编码（对象维度为组织时，选择）'")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty(name = "orgName", value = "组织名称(对象维度为组织时，选择)", required = true)
  @Column(name = "org_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '组织名称（对象维度为组织时，选择）'")
  private String orgName;

  /**
   * 终端编码
   */
  @ApiModelProperty(name = "terminalCode", value = "终端编码", required = true)
  @Column(name = "terminal_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty(name = "terminalName", value = "终端名称", required = true)
  @Column(name = "terminal_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '终端名称'")
  private String terminalName;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(name = "contract_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '合同编码'")
  private String contractCode;

  /**
   * 唯一值，去重时查询用 (类型是单品：产品code + 目标年份 ；类型是层级：产品层级code + 目标年份;类型是常规： 目标年份)
   */
  @ApiModelProperty(name = "onlyKey", value = "唯一值", required = true)
  @Column(name = "only_key", nullable = false, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '唯一值'")
  private String onlyKey;

  /**
   * 商品编码(类型是单品销售目标 该字段不能空)
   */
  @ApiModelProperty(name = "productCode", value = "商品编码", required = true)
  @Column(name = "product_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品编码'")
  private String productCode;

  /**
   * 商品名称(类型是单品销售目标 该字段不能空)
   */
  @ApiModelProperty(name = "productName", value = "商品名称", required = true)
  @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品名称'")
  private String productName;

  /**
   * 商品规格(类型是单品销售目标 该字段不能空)
   */
  @ApiModelProperty(name = "productSpec", value = "商品规格", required = true)
  @Column(name = "product_spec", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品规格'")
  private String productSpec;

  /**
   * 产品层级code(类型是非常规 该字段不能空)
   */
  @ApiModelProperty(name = "productLevelCode", value = "产品层级code", required = true)
  @Column(name = "product_level_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '产品层级code'")
  private String productLevelCode;

  /**
   * 产品层级名称(类型是非常规 该字段不能空)
   */
  @ApiModelProperty(name = "productLevelName", value = "产品层级名称", required = true)
  @Column(name = "product_level_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '产品层级名称'")
  private String productLevelName;


  /**
   * 目标年份总量
   */
  @ApiModelProperty(name = "targetNum", value = "目标年份总量", required = true)
  @Column(name = "target_num", columnDefinition = "decimal(20,4) COMMENT '目标年份总量'")
  private BigDecimal targetNum;

  /**
   * 对象编码
   *
   */
  @ApiModelProperty(name = "objectCode", value = "对象编码", required = true)
  @Column(name = "object_code",nullable = false, length = 128, columnDefinition = "VARCHAR(128)  COMMENT '对象编码'")
  private String objectCode;

  /**
   * 对象名称
   *
   */
  @ApiModelProperty(name = "objectName", value = "对象名称", required = true)
  @Column(name = "object_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128)  COMMENT '对象名称'")
  private String objectName;

  /**
   *  单位类型 0 元，1 万元，2 销售单位 3 基础单位
   */
  @ApiModelProperty(name = "unitType", value = "单位类型 0 元，1 万元，2 销售单位 3 基础单位", required = true)
  @Column(name = "unit_type", nullable = false, columnDefinition = "smallint COMMENT '单位类型 0 元，1 万元，2 销售单位 3 基础单位'")
  private Integer unitType;

  /**
   *  数据状态 0 正常，1 作废
   */
  @ApiModelProperty(name = "dataState", value = "数据状态 0 正常，1 作废", required = true)
  @Column(name = "data_state", nullable = false, columnDefinition = "smallint COMMENT '数据状态 0 正常，1 作废'")
  private Integer dataState;
}
