package com.biz.crm.dms.business.sale.goal.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @description: 销量目标要素实体类
 * @author: rentao
 * @date: 2021/12/1 14:17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SaleGoalElementEntity", description = "销量目标要素实体类")
@Entity
@TableName("dms_sale_goal_element")
@Table(name = "dms_sale_goal_element")
@org.hibernate.annotations.Table(appliesTo = "dms_sale_goal_element", comment = "销量目标要素实体类")
public class SaleGoalElement extends TenantFlagOpEntity {

  /**
   * 任务类型，1 年目标、2 季度目标、3 月度目标
   * */
  @ApiModelProperty("任务类型，1 年目标、2 季度目标、3 月度目标")
  @Column(name = "task_type", nullable = false, columnDefinition = "smallint COMMENT '任务类型，1 年目标、2 季度目标、3 月度目标'")
  private Integer taskType;

  /**
   *  单位类型 0 元，1 万元，2 销售单位 3 基础单位
   */
  @ApiModelProperty(name = "unitType", value = "单位类型 0 元，1 万元，2 销售单位 3 基础单位", required = true)
  @Column(name = "unit_type", nullable = false, columnDefinition = "smallint COMMENT '单位类型 0 元，1 万元，2 销售单位 3 基础单位'")
  private Integer unitType;

  /**
   *  销量目标名称
   */
  @ApiModelProperty(name = "saleGoalName", value = "销量目标名称", required = true)
  @Column(name = "sale_goal_name", nullable = false, columnDefinition = "VARCHAR(128) not null  COMMENT '销量目标名称'")
  private String saleGoalName;

  /**
   *  目标类型 0 常规，1 单品，2 系列
   */
  @ApiModelProperty(name = "saleGoalType", value = " 目标类型 0 常规，1 单品，2 系列", required = true)
  @Column(name = "sale_goal_type", nullable = false, columnDefinition = "smallint COMMENT ' 目标类型 0 常规，1 单品，2 系列'")
  private Integer saleGoalType;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  @Column(name = "cus_code", nullable = false, columnDefinition = "VARCHAR(128) not null  COMMENT '客户编码'")
  private String cusCode;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(name = "contract_code", nullable = false, columnDefinition = "VARCHAR(128) not null  COMMENT '合同编码'")
  private String contractCode;

}
