package com.biz.crm.dms.business.sale.goal.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @description: 销量目标要素明细实体类
 * @author: rentao
 * @date: 2021/12/1 14:17
 */

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SaleGoalElementDetailEntity", description = "销量目标要素明细实体类")
@Entity
@TableName("dms_sale_goal_element_detail")
@Table(name = "dms_sale_goal_element_detail")
@org.hibernate.annotations.Table(appliesTo = "dms_sale_goal_element_detail", comment = "销量目标要素明细实体类")
public class SaleGoalElementDetail extends UuidFlagOpEntity {

  /**
   * 合同编码
   *
   * */
  @ApiModelProperty(name = "contractCode", value = "销量目标主表id", required = true)
  @Column(name = "contract_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '合同编码'")
  private  String contractCode;

  /**
   * 销量目标主表id
   */
  @ApiModelProperty(name = "saleGoalElementId", value = "销量目标主表id", required = true)
  @Column(name = "sale_goal_element_id", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '销量目标主表id'")
  private String saleGoalElementId;

  /**
   * 目标年份
   */
  @ApiModelProperty(name = "targetYear", value = "目标年份", required = true)
  @Column(name = "target_year", nullable = false, columnDefinition = "smallint COMMENT '目标年份'")
  private Integer targetYear;

  /**
   * 目标年份总量
   */
  @ApiModelProperty(name = "targetNum", value = "目标年份总量", required = true)
  @Column(name = "target_num", columnDefinition = "decimal(20,4) COMMENT '目标年份总量'")
  private BigDecimal targetNum;

  /**
   * 产品层级code(类型是非常规 该字段不能空)
   */
  @ApiModelProperty(name = "productLevelCode", value = "产品层级code", required = true)
  @Column(name = "product_level_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '产品层级code'")
  private String productLevelCode;

  /**
   * 产品层级名称(类型是非常规 该字段不能空)
   */
  @ApiModelProperty(name = "productLevelName", value = "产品层级名称", required = true)
  @Column(name = "product_level_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '产品层级名称'")
  private String productLevelName;

  /**
   * 商品编码(类型是单品销售目标 该字段不能空)
   */
  @ApiModelProperty(name = "productCode", value = "商品编码", required = true)
  @Column(name = "product_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品编码'")
  private String productCode;

  /**
   * 商品名称(类型是单品销售目标 该字段不能空)
   */
  @ApiModelProperty(name = "productName", value = "商品名称", required = true)
  @Column(name = "product_name",length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品名称'")
  private String productName;

  /**
   * 商品规格(类型是单品销售目标 该字段不能空)
   */
  @ApiModelProperty(name = "productSpec", value = "商品规格", required = true)
  @Column(name = "product_spec",length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品规格'")
  private String productSpec;

  /**
   * 一月目标销量
   */
  @ApiModelProperty(name = "janTargetNum", value = "一月目标销量", required = true)
  @Column(name = "jan_target_num", columnDefinition = "decimal(20,4) COMMENT '一月目标销量'")
  private BigDecimal janTargetNum;

  /**
   * 二月目标销量
   */
  @ApiModelProperty(name = "janTargetNum", value = "二月目标销量", required = true)
  @Column(name = "feb_target_num", columnDefinition = "decimal(20,4) COMMENT '二月目标销量'")
  private BigDecimal febTargetNum;

  /**
   * 三月目标销量
   */
  @ApiModelProperty(name = "marTargetNum", value = "三月目标销量", required = true)
  @Column(name = "marTargetNum", columnDefinition = "decimal(20,4) COMMENT '三月目标销量'")
  private BigDecimal marTargetNum;

  /**
   * 四月目标销量
   */
  @ApiModelProperty(name = "aprTargetNum", value = "四月目标销量", required = true)
  @Column(name = "apr_target_num", columnDefinition = "decimal(20,4) COMMENT '四月目标销量'")
  private BigDecimal aprTargetNum;

  /**
   * 五月目标销量
   */
  @ApiModelProperty(name = "mayTargetNum", value = "五月目标销量", required = true)
  @Column(name = "may_target_num", columnDefinition = "decimal(20,4) COMMENT '五月目标销量'")
  private BigDecimal mayTargetNum;

  /**
   * 六月目标销量
   */
  @ApiModelProperty(name = "junTargetNum", value = "六月目标销量", required = true)
  @Column(name = "jun_target_num", columnDefinition = "decimal(20,4) COMMENT '六月目标销量'")
  private BigDecimal junTargetNum;

  /**
   * 七月目标销量
   */
  @ApiModelProperty(name = "junTargetNum", value = "七月目标销量", required = true)
  @Column(name = "jul_target_num", columnDefinition = "decimal(20,4) COMMENT '七月目标销量'")
  private BigDecimal julTargetNum;

  /**
   * 八月目标销量
   */
  @ApiModelProperty(name = "augTargetNum", value = "八月目标销量", required = true)
  @Column(name = "aug_target_num", columnDefinition = "decimal(20,4) COMMENT '八月目标销量'")
  private BigDecimal augTargetNum;

  /**
   * 九月目标销量
   */
  @ApiModelProperty(name = "sepTargetNum", value = "九月目标销量", required = true)
  @Column(name = "sep_target_num", columnDefinition = "decimal(20,4) COMMENT '九月目标销量'")
  private BigDecimal sepTargetNum;

  /**
   * 十月目标销量
   */
  @ApiModelProperty(name = "octTargetNum", value = "十月目标销量", required = true)
  @Column(name = "oct_target_num", columnDefinition = "decimal(20,4) COMMENT '十月目标销量'")
  private BigDecimal octTargetNum;

  /**
   * 十一月目标销量
   */
  @ApiModelProperty(name = "novTargetNum", value = "十一月目标销量", required = true)
  @Column(name = "nov_target_num", columnDefinition = "decimal(20,4) COMMENT '十一月目标销量'")
  private BigDecimal novTargetNum;

  /**
   * 十二月目标销量
   */
  @ApiModelProperty(name = "decTargetNum", value = "十二月目标销量", required = true)
  @Column(name = "dec_target_num", columnDefinition = "decimal(20,4) COMMENT '十二月目标销量'")
  private BigDecimal decTargetNum;

  /**
   * 第一季度目标销量
   */
  @ApiModelProperty(name = "firstQuarterNum", value = "第一季度目标销量", required = true)
  @Column(name = "first_quarter_num", columnDefinition = "decimal(20,4) COMMENT '第一季度目标销量'")
  private BigDecimal firstQuarterNum;

  /**
   * 第二季度目标销量
   */
  @ApiModelProperty(name = "secondQuarterNum", value = "第二季度目标销量", required = true)
  @Column(name = "second_quarter_num", columnDefinition = "decimal(20,4) COMMENT '第二季度目标销量'")
  private BigDecimal secondQuarterNum;

  /**
   * 第三季度目标销量
   */
  @ApiModelProperty(name = "thirdQuarterNum", value = "第三季度目标销量", required = true)
  @Column(name = "third_quarter_num", columnDefinition = "decimal(20,4) COMMENT '第三季度目标销量'")
  private BigDecimal thirdQuarterNum;

  /**
   * 第四季度目标销量
   */
  @ApiModelProperty(name = "fourthQuarterNum", value = "第四季度目标销量", required = true)
  @Column(name = "fourth_quarter_num", columnDefinition = "decimal(20,4) COMMENT '第四季度目标销量'")
  private BigDecimal fourthQuarterNum;

  /**
   * 年度目标销量
   */
  @ApiModelProperty(name = "yearlyNum", value = "年度目标销量", required = true)
  @Column(name = "yearly_num", columnDefinition = "decimal(20,4) COMMENT '年度目标销量'")
  private BigDecimal yearlyNum;

  /**
   * 第一季度目标销量汇总
   */
  @ApiModelProperty(name = "firstQuarterSum", value = "第一季度目标销量汇总", required = true)
  @Column(name = "first_quarter_sum", columnDefinition = "decimal(20,4) COMMENT '第一季度目标销量汇总'")
  private BigDecimal firstQuarterSum;

  /**
   * 第二季度目标销量汇总
   */
  @ApiModelProperty(name = "secondQuarterSum", value = "第二季度目标销量汇总", required = true)
  @Column(name = "second_quarter_sum", columnDefinition = "decimal(20,4) COMMENT '第二季度目标销量汇总'")
  private BigDecimal secondQuarterSum;

  /**
   * 第三季度目标销量汇总
   */
  @ApiModelProperty(name = "thirdQuarterSum", value = "第三季度目标销量汇总", required = true)
  @Column(name = "third_quarter_sum", columnDefinition = "decimal(20,4) COMMENT '第三季度目标销量汇总'")
  private BigDecimal thirdQuarterSum;

  /**
   * 第四季度目标销量汇总
   */
  @ApiModelProperty(name = "fourthQuarterSum", value = "第四季度目标销量汇总", required = true)
  @Column(name = "fourth_quarter_sum", columnDefinition = "decimal(20,4) COMMENT '第四季度目标销量汇总'")
  private BigDecimal fourthQuarterSum;

  /**
   * 年度目标销量
   */
  @ApiModelProperty(name = "yearlySum", value = "年度目标销量汇总", required = true)
  @Column(name = "yearly_sum", columnDefinition = "decimal(20,4) COMMENT '年度目标销量汇总'")
  private BigDecimal yearlySum;

  /**
   * 唯一键
   */
  @ApiModelProperty(name = "onlyKey", value = "唯一键", required = true)
  @Column(name = "only_key", nullable = false, columnDefinition = "VARCHAR(128) not null  COMMENT '唯一键'")
  private String onlyKey;




}
