package com.biz.crm.dms.business.sale.goal.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.sale.goal.dto.SaleGoalDto;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoal;
import org.apache.ibatis.annotations.Param;

/**
 * @description: 销量目标表的mybatis-plus接口类 {@link SaleGoal}
 * @author: rentao
 * @date: 2021/11/30 11:07
 */
public interface SaleGoalMapper extends BaseMapper<SaleGoal> {

  /**
   * 销量目标分页列表
   *
   * @param page 销量目标信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<SaleGoal> findByConditions(Page<SaleGoal> page, @Param("dto") SaleGoalDto dto);
}
