package com.biz.crm.dms.business.sale.goal.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoalDetail;
import com.biz.crm.dms.business.sale.goal.local.mapper.SaleGoalDetailMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 销量目标明细
 * @author: rentao
 * @date: 2021/11/30 11:07
 */
@Component
public class SaleGoalDetailRepository extends ServiceImpl<SaleGoalDetailMapper, SaleGoalDetail> {

  /**
   * 销量目标id 查询详情
   *
   * @param saleGoalId
   * @author rentao
   * @date
   */
  public SaleGoalDetail findDetailsById(String saleGoalId) {
    if (StringUtils.isBlank(saleGoalId)) {
      return null;
    }
    return this.lambdaQuery().eq(SaleGoalDetail::getSaleGoalId, saleGoalId).one();
  }
}
