package com.biz.crm.dms.business.sale.goal.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoalElementDetail;
import com.biz.crm.dms.business.sale.goal.local.mapper.SaleGoalElementDetailMapper;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * @description: 销量目标要素明细
 * @author: rentao
 * @date: 2021/12/6 19:35
 */
@Component
public class SaleGoalElementDetailRepository
    extends ServiceImpl<SaleGoalElementDetailMapper, SaleGoalElementDetail> {

  /**
   * 通过合同编码删除可购
   *
   * @param onlyKeys 唯一键确认
   */
  public List<SaleGoalElementDetail> findByOnlyKeys(Set<String> onlyKeys) {
    return this.lambdaQuery()
        .in(SaleGoalElementDetail::getOnlyKey, onlyKeys)
        .orderByDesc(SaleGoalElementDetail::getCreateTime)
        .list();
  }

  /**
   * 通过销量要素主表id查询关联明细
   *
   * @param saleGoalElementId 销量要素主表id
   */
  public List<SaleGoalElementDetail> findBySaleGoalElementId(String saleGoalElementId) {
    return this.lambdaQuery()
        .in(SaleGoalElementDetail::getSaleGoalElementId, saleGoalElementId)
        .orderByDesc(SaleGoalElementDetail::getCreateTime)
        .list();
  }

  /**
   * 通过销量要素主表id删除关联明细
   *
   * @param saleGoalElementId 销量要素主表id
   */
  public void deleteBySaleGoalElementId(String saleGoalElementId) {
    this.lambdaUpdate().eq(SaleGoalElementDetail::getSaleGoalElementId, saleGoalElementId).remove();
  }
}
