package com.biz.crm.dms.business.sale.goal.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoalElement;
import com.biz.crm.dms.business.sale.goal.local.mapper.SaleGoalElementMapper;
import org.springframework.stereotype.Component;

/**
 * @description: 销量目标要素
 * @author: rentao
 * @date: 2021/12/1 20:16
 */
@Component
public class SaleGoalElementRepository extends ServiceImpl<SaleGoalElementMapper, SaleGoalElement> {

  public SaleGoalElement findBySaleGoalTypeAndContractCode(
      Integer saleGoalType, String contractCode) {
    return this.lambdaQuery()
        .eq(SaleGoalElement::getSaleGoalType, saleGoalType)
        .eq(SaleGoalElement::getContractCode, contractCode)
        .orderByDesc(SaleGoalElement::getCreateTime)
        .one();
  }
}
