package com.biz.crm.dms.business.sale.goal.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.sale.goal.local.mapper.SaleGoalMapper;
import com.biz.crm.dms.business.sale.goal.dto.SaleGoalDto;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoal;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import org.springframework.util.CollectionUtils;

/**
 * @description: 销量目标
 * @author: rentao
 * @date: 2021/11/30 11:07
 */
@Component
public class SaleGoalRepository extends ServiceImpl<SaleGoalMapper, SaleGoal> {

  /**
   * 批量更新启用禁用状态
   *
   * @param ids ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(SaleGoal::getId, ids)
        .set(SaleGoal::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(SaleGoal::getId, ids)
        .set(SaleGoal::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }


  /**
   * 根据主键集合，修改 enable_status
   *
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    this.lambdaUpdate()
        .set(SaleGoal::getEnableStatus, enable.getCode())
        .eq(SaleGoal::getTenantCode, TenantUtils.getTenantCode())
        .in(SaleGoal::getId, ids)
        .update();
  }

  /**
   * 公告分页列表
   *
   * @param dto 请求参数dto
   * @param pageable 分页信息
   * @return Page<NoticeEntity>公告分页信息
   */
  public Page<SaleGoal> findByConditions(Pageable pageable, SaleGoalDto dto) {
    Page<SaleGoal> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  public List<SaleGoal> findByOnlyKeysAndDelFlag(List<String> onlyKeyList, String delFlagStatus) {
    return this.lambdaQuery()
        .in(SaleGoal::getOnlyKey, onlyKeyList)
        .eq(SaleGoal::getDelFlag, delFlagStatus)
        .eq(SaleGoal::getTenantCode, TenantUtils.getTenantCode())
        .list();
  };

  public List<SaleGoal> findByContractCodeAndDelFlag(
      List<String> contractCodes, String delFlagStatus) {
    return this.lambdaQuery()
        .in(SaleGoal::getContractCode, contractCodes)
        .eq(SaleGoal::getDelFlag, delFlagStatus)
        .eq(SaleGoal::getTenantCode, TenantUtils.getTenantCode())
        .list();
  };
}
