package com.biz.crm.dms.business.sale.goal.local.service;

import com.biz.crm.dms.business.sale.goal.vo.element.SaleGoalRoutineElementDataVo;

/**
 * @description: 常规销量目标要素service
 * @author: rentao
 * @date: 2021/12/1 19:21
 */
public interface SaleGoalRoutineElementService {

  /**
   * 合同编码查询合同内容
   *
   * @param contractcode
   * @author rentao
   * @date
   */
  SaleGoalRoutineElementDataVo findByContractCode(String contractcode);

  /**
   * 要素内容新增
   *
   * @param contractCode
   * @param saleGoalRoutineElementDataVo
   * @param indexCode
   * @author rentao
   * @date
   */
  SaleGoalRoutineElementDataVo createSaleGoalRoutineElement(
      String contractCode,
      SaleGoalRoutineElementDataVo saleGoalRoutineElementDataVo,
      Integer indexCode);

  /**
   * 要素内容修改
   *
   * @param contractCode
   * @param saleGoalRoutineElementDataVo
   * @param indexCode
   * @author rentao
   * @date
   */
  SaleGoalRoutineElementDataVo updateSaleGoalRoutineElement(
      String contractCode,
      SaleGoalRoutineElementDataVo saleGoalRoutineElementDataVo,
      Integer indexCode);
}
