package com.biz.crm.dms.business.sale.goal.local.service;

import com.biz.crm.dms.business.sale.goal.vo.element.SaleGoalSeriesElementDataVo;

/**
 * @description: 系列销量目标要素service
 * @author: rentao
 * @date: 2021/12/1 19:21
 */
public interface SaleGoalSeriesElementService {

  /**
   * 合同编码查询合同内容
   *
   * @param contractCode
   * @author rentao
   * @date
   */
  SaleGoalSeriesElementDataVo findByContractCode(String contractCode);

  /**
   * 要素内容新增
   *
   * @param contractCode
   * @param saleGoalSeriesElementDataVo
   * @param indexCode
   * @author rentao
   * @date
   */
  SaleGoalSeriesElementDataVo createSaleGoalSeriesElement(
      String contractCode,
      SaleGoalSeriesElementDataVo saleGoalSeriesElementDataVo,
      Integer indexCode);

  /**
   * 要素内容修改
   *
   * @param contractCode
   * @param saleGoalSeriesElementDataVo
   * @param indexCode
   * @author rentao
   * @date
   */
  SaleGoalSeriesElementDataVo updateSaleGoalSeriesElement(
      String contractCode,
      SaleGoalSeriesElementDataVo saleGoalSeriesElementDataVo,
      Integer indexCode);
}
