package com.biz.crm.dms.business.sale.goal.local.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractEventDto;
import com.biz.crm.dms.business.contract.sdk.event.contract.ContractManagementEventListener;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.biz.crm.dms.business.sale.goal.dto.SaleGoalDto;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoal;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;

import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 销量目标 service
 * @author: rentao
 * @date: 2021/11/30 11:05
 */
public interface SaleGoalService {

  /**
   * 销量目标分页列表
   *
   * @param dto 请求参数dto
   * @param pageable 分页信息
   * @return Page<SaleGoal> 销量目标分页信息
   */
  Page<SaleGoal> findByConditions(Pageable pageable, SaleGoalDto dto);

  /**
   * 创建销量目标
   *
   * @param saleGoalDtos 参数dto
   * @return 创建的销量目标
   */
  List<SaleGoal> createBatch(List<SaleGoalDto> saleGoalDtos);

  /**
   * 更新销量目标
   *
   * @param dto 参数dto
   * @return 更新的销量目标
   */
  SaleGoal update(SaleGoalDto dto);

  /**
   * 批量删除销量目标
   *
   * @param ids 销量目标id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量删除销量目标
   *
   * @param contractCodes 合同编码集合
   */
  void deleteBatchByContractCodes(List<String> contractCodes);


  /**
   * 批量启用（通过合同编码）
   *
   * @param
   */
  void enableBatchByContractCode(List<String> contractCodes);


  /**
   * 批量禁用（通过合同编码）
   *
   * @param
   */
  void disableBatchByContractCode(List<String> contractCodes);
}
