package com.biz.crm.dms.business.sale.goal.local.service;

import com.biz.crm.dms.business.sale.goal.vo.element.SaleGoalSingleElementDataVo;

/**
 * @description: 单品销量目标要素service
 * @author: rentao
 * @date: 2021/12/1 14:44
 */
public interface SaleGoalSingleElementService {

  /**
   * 合同编码查询合同内容
   *
   * @param contractcode
   * @author rentao
   * @date
   */
  SaleGoalSingleElementDataVo findByContractCode(String contractcode);

  /**
   * 要素内容新增
   *
   * @param contractCode
   * @param allowSaleElementDataVo
   * @param indexCode
   * @author rentao
   * @date
   */
  SaleGoalSingleElementDataVo createSaleGoalSingleElement(
      String contractCode, SaleGoalSingleElementDataVo allowSaleElementDataVo, Integer indexCode);

  /**
   * 要素内容修改
   *
   * @param contractCode
   * @param allowSaleElementDataVo
   * @param indexCode
   * @author rentao
   * @date
   */
  SaleGoalSingleElementDataVo updateSaleGoalSingleElement(
      String contractCode, SaleGoalSingleElementDataVo allowSaleElementDataVo, Integer indexCode);
}
