package com.biz.crm.dms.business.sale.goal.local.service.internal;

import com.biz.crm.dms.business.sale.goal.local.utils.SaleGoalItemUtil;
import com.biz.crm.dms.business.sale.goal.dto.SaleGoalDetailDto;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoalDetail;
import com.biz.crm.dms.business.sale.goal.local.repository.SaleGoalDetailRepository;
import com.biz.crm.dms.business.sale.goal.local.service.SaleGoalDetailService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 销量目标明细 Service
 * @author: rentao
 * @date: 2021/11/30 11:06
 */
@Service
@Slf4j
public class SaleGoalDetailServiceImpl implements SaleGoalDetailService {

  @Autowired(required = false) private SaleGoalDetailRepository saleGoalDetailRepository;

  /**
   * 销量目标id 查询 销量目标明细
   *
   * @param saleGoalId
   * @author rentao
   * @date
   */
  @Override
  public SaleGoalDetail findDetailsById(String saleGoalId) {
    return this.saleGoalDetailRepository.findDetailsById(saleGoalId);
  }

  /**
   * 批量保存目标
   *
   * @param saleGoalDetailDtos
   */
  @Override
  @Transactional
  public void createBatch(List<SaleGoalDetailDto> saleGoalDetailDtos) {
    if (CollectionUtils.isEmpty(saleGoalDetailDtos)) {
      return;
    }
    List<SaleGoalDetail> entities = new ArrayList<>(saleGoalDetailDtos.size());
    for (SaleGoalDetailDto detailDto : saleGoalDetailDtos) {
      entities.add(SaleGoalItemUtil.packageEntityForAddBatch(detailDto));
    }
    this.saleGoalDetailRepository.saveBatch(entities);
  }

  /**
   * 更新目标
   *
   * @param saleGoalDetailDto
   */
  @Override
  @Transactional
  public void update(SaleGoalDetailDto saleGoalDetailDto) {
    Validate.notBlank(saleGoalDetailDto.getId(), "请指定要编辑的销售目标明细!");
    SaleGoalDetail entity = this.saleGoalDetailRepository.getById(saleGoalDetailDto.getId());
    Validate.notNull(entity, "您要编辑的销售目标明细不存在或者已经被删除!");
    SaleGoalDetail currentEntity = SaleGoalItemUtil.packageEntityForUpdate(saleGoalDetailDto);
    this.saleGoalDetailRepository.updateById(currentEntity);
  }
}
