package com.biz.crm.dms.business.sale.goal.local.service.internal;

import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoalDetail;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoal;
import com.biz.crm.dms.business.sale.goal.local.repository.SaleGoalRepository;
import com.biz.crm.dms.business.sale.goal.local.service.SaleGoalDetailService;
import com.biz.crm.dms.business.sale.goal.service.SaleGoalVoService;
import com.biz.crm.dms.business.sale.goal.vo.SaleGoalDetailVo;
import com.biz.crm.dms.business.sale.goal.vo.SaleGoalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * @description: 销量目标vo service
 * @author: rentao
 * @date: 2021/11/30 14:34
 */
@Service
@Slf4j
public class SaleGoalVoServiceImpl implements SaleGoalVoService {

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false) private SaleGoalRepository saleGoalRepository;

  @Autowired(required = false) private SaleGoalDetailService saleGoalDetailService;

  /**
   * 通过id查询销量目标详情
   * @param id
   * @author rentao
   * @date
   */
  @Override
  public SaleGoalVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    SaleGoal entity = this.saleGoalRepository.getById(id);
    if (Objects.isNull(entity)) {
      return null;
    }
    SaleGoalVo saleGoalVo =
        this.nebulaToolkitService.copyObjectByBlankList(
            entity, SaleGoalVo.class, HashSet.class, ArrayList.class);
    SaleGoalDetail saleGoalDetail = this.saleGoalDetailService.findDetailsById(saleGoalVo.getId());
    if (Objects.nonNull(saleGoalDetail)) {
      SaleGoalDetailVo saleGoalDetailVo =
          this.nebulaToolkitService.copyObjectByWhiteList(
              saleGoalDetail, SaleGoalDetailVo.class, HashSet.class, ArrayList.class);
      saleGoalVo.setSaleGoalDetailVo(saleGoalDetailVo);
    }
    return saleGoalVo;
  }
}
