package com.biz.crm.dms.business.sale.goal.local.service.register;

import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.sale.goal.local.service.SaleGoalRoutineElementService;
import com.biz.crm.dms.business.sale.goal.vo.element.SaleGoalRoutineElementDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 常规销量目标 注册器实现
 * @author: rentao
 * @date: 2021/12/1 19:01
 */
public class SaleGoalRoutineElementRegisterImpl
    implements ContractElementRegister<SaleGoalRoutineElementDataVo> {

  @Autowired(required = false) private SaleGoalRoutineElementService saleGoalRoutineElementService;

  /** 合同要素编码 */
  private static final String CONTRACT_ELEMENT_CODE = "saleGoalRoutineElementRegister";

  /** 合同要素组件名称 */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-salegoal";

  /** 合同要素名称 */
  private static final String CONTRACT_ELEMENT_NAME = "常规销量目标";

  /** 合同要素排序 */
  private static final Integer ELEMENT_SORT = 5;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<SaleGoalRoutineElementDataVo> getContractElementClass() {
    return SaleGoalRoutineElementDataVo.class;
  }

  @Override
  public SaleGoalRoutineElementDataVo getByContractCode(String contractcode) {
    return this.saleGoalRoutineElementService.findByContractCode(contractcode);
  }

  @Override
  @Transactional
  public SaleGoalRoutineElementDataVo onRequestContractCreate(
      String contractCode,
      SaleGoalRoutineElementDataVo saleGoalRoutineElementDataVo,
      Integer indexCode) {
    return this.saleGoalRoutineElementService.createSaleGoalRoutineElement(
        contractCode, saleGoalRoutineElementDataVo, indexCode);
  }

  @Override
  @Transactional
  public SaleGoalRoutineElementDataVo onRequestContractUpdate(
      String contractCode,
      SaleGoalRoutineElementDataVo saleGoalRoutineElementDataVo,
      Integer indexCode) {
    return this.saleGoalRoutineElementService.updateSaleGoalRoutineElement(
        contractCode, saleGoalRoutineElementDataVo, indexCode);
  }
}
