package com.biz.crm.dms.business.sale.goal.local.service.register;

import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.sale.goal.local.service.SaleGoalSeriesElementService;
import com.biz.crm.dms.business.sale.goal.vo.element.SaleGoalSeriesElementDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 系列销量目标 要素注册器实现
 * @author: rentao
 * @date: 2021/12/1 19:02
 */
public class SaleGoalSeriesElementRegisterImpl
    implements ContractElementRegister<SaleGoalSeriesElementDataVo> {

  @Autowired(required = false) private SaleGoalSeriesElementService saleGoalSeriesElementService;

  /** 合同要素编码 */
  private static final String CONTRACT_ELEMENT_CODE = "saleGoalSeriesElementRegister";

  /** 合同要素组件名称 */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-salegoal";

  /** 合同要素名称 */
  private static final String CONTRACT_ELEMENT_NAME = "系列销量目标";

  /** 合同要素排序 */
  private static final Integer ELEMENT_SORT = 4;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<SaleGoalSeriesElementDataVo> getContractElementClass() {
    return SaleGoalSeriesElementDataVo.class;
  }

  @Override
  public SaleGoalSeriesElementDataVo getByContractCode(String contractcode) {
    return this.saleGoalSeriesElementService.findByContractCode(contractcode);
  }

  @Override
  @Transactional
  public SaleGoalSeriesElementDataVo onRequestContractCreate(
      String contractCode,
      SaleGoalSeriesElementDataVo saleGoalSeriesElementDataVo,
      Integer indexCode) {
    return this.saleGoalSeriesElementService.createSaleGoalSeriesElement(
        contractCode, saleGoalSeriesElementDataVo, indexCode);
  }

  @Override
  @Transactional
  public SaleGoalSeriesElementDataVo onRequestContractUpdate(
      String contractCode,
      SaleGoalSeriesElementDataVo saleGoalSeriesElementDataVo,
      Integer indexCode) {
    return this.saleGoalSeriesElementService.updateSaleGoalSeriesElement(
        contractCode, saleGoalSeriesElementDataVo, indexCode);
  }
}
