package com.biz.crm.dms.business.sale.goal.local.service.register;

import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.sale.goal.local.service.SaleGoalSingleElementService;
import com.biz.crm.dms.business.sale.goal.vo.element.SaleGoalSingleElementDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 单品销量目标 要素注册器实现
 * @author: rentao
 * @date: 2021/12/1 14:33
 */
public class SaleGoalSingleElementRegisterImpl
    implements ContractElementRegister<SaleGoalSingleElementDataVo> {

  @Autowired(required = false) private SaleGoalSingleElementService saleGoalElementService;

  /** 合同要素编码 */
  private static final String CONTRACT_ELEMENT_CODE = "saleGoalSingleElementRegister";

  /** 合同要素组件名称 */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-salegoal";

  /** 合同要素名称 */
  private static final String CONTRACT_ELEMENT_NAME = "单品销量目标";

  /** 合同要素排序 */
  private static final Integer ELEMENT_SORT = 3;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<SaleGoalSingleElementDataVo> getContractElementClass() {
    return SaleGoalSingleElementDataVo.class;
  }

  @Override
  public SaleGoalSingleElementDataVo getByContractCode(String contractcode) {
    return this.saleGoalElementService.findByContractCode(contractcode);
  }

  @Override
  @Transactional
  public SaleGoalSingleElementDataVo onRequestContractCreate(
      String contractCode, SaleGoalSingleElementDataVo saleGoalDataVo, Integer indexCode) {
    return this.saleGoalElementService.createSaleGoalSingleElement(
        contractCode, saleGoalDataVo, indexCode);
  }

  @Override
  @Transactional
  public SaleGoalSingleElementDataVo onRequestContractUpdate(
      String contractCode, SaleGoalSingleElementDataVo saleGoalDataVo, Integer indexCode) {
    return this.saleGoalElementService.updateSaleGoalSingleElement(
        contractCode, saleGoalDataVo, indexCode);
  }
}
