package com.biz.crm.dms.business.sale.goal.local.utils;

import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Map;

/**
 * @description: 对象字段处理 util
 * @author: rentao
 * @date: 2021/12/1 11:00
 */
@Slf4j
public class FieldHandleUtil {

  /**
   * 获取对象中指定的字段值
   * @param o
   * @param fieldNames
   * @return
   */
  public static Map<String, Object> fieldsValue(Object o, String... fieldNames) {
    Map<String, Object> result = Maps.newHashMap();
    try {
      Class c = o.getClass();
      for (String fieldName : fieldNames) {
        Field field = c.getDeclaredField(fieldName);
        field.setAccessible(true);
        result.put(fieldName, field.get(o));
      }
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Maps.newHashMap();
    }
    return result;
  }


  /**
   * 初始化为null的，{@link BigDecimal}类型字段
   * @param v
   */
  public static void initDecimalZero(Object v) {
    Class c = v.getClass();
    try {
      Field[] fields = c.getDeclaredFields();
      if (fields == null) {
        return;
      }
      for (Field field : fields) {
        field.setAccessible(true);
        if (field.getType() == BigDecimal.class && field.get(v) == null) {
          field.set(v, BigDecimal.ZERO);
        }
      }
    } catch (IllegalAccessException e) {
      log.error("data:{}", v);
      throw new IllegalArgumentException("处理空数字字段异常");
    }
  }
}
