package com.biz.crm.dms.business.sale.goal.local.utils;

import com.biz.crm.dms.business.sale.goal.dto.SaleGoalDetailDto;
import com.biz.crm.dms.business.sale.goal.enums.TaskType;
import com.biz.crm.dms.business.sale.goal.local.entity.SaleGoalDetail;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;

/**
 * @description: 销量目标明细 util
 * @author: rentao
 * @date: 2021/12/1 11:06
 */
public class SaleGoalItemUtil {

  /**
   * 为addBatch方法组装对象
   * @param detailDto
   * @return
   */
  public static SaleGoalDetail packageEntityForAddBatch(SaleGoalDetailDto detailDto) {
    sumSingleItem(detailDto);
    SaleGoalDetail entity = new SaleGoalDetail();
    BeanUtils.copyProperties(detailDto, entity);
    return entity;
  }

  /**
   * 组装销售目标明细编辑参数
   * @param saleGoalDetailDto
   */
  public static SaleGoalDetail packageEntityForUpdate(SaleGoalDetailDto saleGoalDetailDto) {
    sumSingleItem(saleGoalDetailDto);
    SaleGoalDetail entity = new SaleGoalDetail();
    BeanUtils.copyProperties(saleGoalDetailDto, entity);
    return entity;
  }

  /**
   * 汇总明细内部数据
   * @param detailDto
   */
  public static SaleGoalDetailDto sumSingleItem(SaleGoalDetailDto detailDto) {
    FieldHandleUtil.initDecimalZero(detailDto);
    TaskType taskType = TaskType.getByKey(detailDto.getTaskType());
    Validate.notNull(taskType, "汇总目标明细时，没有获取到任务类型");
    BigDecimal yearSum = BigDecimal.ZERO;
    switch (taskType) {
      case YEARLY:
        //设置年度汇总
        Validate.isTrue(detailDto.getYearlyNum().compareTo(BigDecimal.ZERO) > 0 ,"年度汇总数不能小于0");
        detailDto.setYearlySum(detailDto.getYearlyNum());
        break;
      case QUARTER:
        //计算年度汇总
        yearSum = yearSum.add(detailDto.getFirstQuarterNum())
            .add(detailDto.getSecondQuarterNum())
            .add(detailDto.getThirdQuarterNum())
            .add(detailDto.getFourthQuarterNum());
        Validate.isTrue(yearSum.compareTo(BigDecimal.ZERO) > 0 ,"年度汇总数不能小于0");
        detailDto.setYearlySum(yearSum);
        //计算季度汇总
        detailDto.setFirstQuarterSum(detailDto.getFirstQuarterNum());
        detailDto.setSecondQuarterSum(detailDto.getSecondQuarterNum());
        detailDto.setThirdQuarterSum(detailDto.getThirdQuarterNum());
        detailDto.setFourthQuarterSum(detailDto.getFourthQuarterNum());
        break;
      case MONTHLY:
        //第一季度汇总
        BigDecimal firstQuarterSum = detailDto.getJanTargetNum()
            .add(detailDto.getFebTargetNum())
            .add(detailDto.getMarTargetNum());
        detailDto.setFirstQuarterSum(firstQuarterSum);
        //第二季度汇总
        BigDecimal secondQuarterSum = detailDto.getAprTargetNum()
            .add(detailDto.getMayTargetNum())
            .add(detailDto.getJunTargetNum());
        detailDto.setSecondQuarterSum(secondQuarterSum);
        //第三季度汇总
        BigDecimal thirdQuarterSum = detailDto.getJulTargetNum()
            .add(detailDto.getAugTargetNum())
            .add(detailDto.getFebTargetNum());
        detailDto.setThirdQuarterSum(thirdQuarterSum);
        //第四季度汇总
        BigDecimal fourthQuarterSum = detailDto.getOctTargetNum()
            .add(detailDto.getDecTargetNum())
            .add(detailDto.getNovTargetNum());
        detailDto.setFourthQuarterSum(fourthQuarterSum);
        //年度汇总
        yearSum = firstQuarterSum.add(secondQuarterSum)
            .add(thirdQuarterSum)
            .add(fourthQuarterSum);
        Validate.isTrue(yearSum.compareTo(BigDecimal.ZERO) > 0 ,"年度汇总数不能小于0");
        detailDto.setYearlySum(yearSum);
        break;
      default:
        break;
    }
    return detailDto;
  }

  /**
   * 将vo中的目标数字转换成字符串PC端
   * @param detailDto
   */
  public static void salesTargetToStr(SaleGoalDetailDto detailDto) {
    if (null != detailDto) {
      if (null != detailDto.getJanTargetNum()) {
        detailDto.setJanTargetNumStr(detailDto.getJanTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getFebTargetNum()) {
        detailDto.setFebTargetNumStr(detailDto.getFebTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getMarTargetNum()) {
        detailDto.setMarTargetNumStr(detailDto.getMarTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getAprTargetNum()) {
        detailDto.setAprTargetNumStr(detailDto.getAprTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getMayTargetNum()) {
        detailDto.setMayTargetNumStr(detailDto.getMayTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getJunTargetNum()) {
        detailDto.setJunTargetNumStr(detailDto.getJunTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getJulTargetNum()) {
        detailDto.setJulTargetNumStr(detailDto.getJulTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getAugTargetNum()) {
        detailDto.setAugTargetNumStr(detailDto.getAugTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getSepTargetNum()) {
        detailDto.setSepTargetNumStr(detailDto.getSepTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getOctTargetNum()) {
        detailDto.setOctTargetNumStr(detailDto.getOctTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getNovTargetNum()) {
        detailDto.setNovTargetNumStr(detailDto.getNovTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != detailDto.getDecTargetNum()) {
        detailDto.setDecTargetNumStr(detailDto.getDecTargetNum().stripTrailingZeros().toPlainString());
      }
    }
  }

}
