package com.biz.crm.dms.business.sale.goal.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @description: 销量目标dto
 * @author: rentao
 * @date: 2021/11/30 11:08
 */
@Data
@ApiModel(value = "SaleGoalDto", description = "销量目标dto")
public class SaleGoalDto extends TenantFlagOpDto {

  /** 客户编码 */
  @ApiModelProperty(value = "客户编码")
  private String cusCode;

  /** 年度类型 1 自然年 2 企业财年 */
  @ApiModelProperty(value = "年度类型  1 自然年 2 企业财年")
  private Integer targetYearType;

  /** 客户名称 */
  @ApiModelProperty(value = "客户名称")
  private String cusName;

  /** 客户所属组织编码 */
  @ApiModelProperty(value = "客户所属组织编码")
  private String cusOrgCode;

  /** 客户所属组织名称 */
  @ApiModelProperty(value = "客户所属组织名称")
  private String cusOrgName;

  /** 客户所属渠道编码 */
  @ApiModelProperty(value = "客户所属渠道编码")
  private String cusChannelCode;

  /** 客户所属渠道名称 */
  @ApiModelProperty(value = "客户所属渠道名称")
  private String cusChannelName;

  /** 销售区域编码 */
  @ApiModelProperty(value = "销售区域编码")
  private String salesAreaCode;

  /** 销售区域名称 */
  @ApiModelProperty(value = "销售区域名称")
  private String salesAreaName;

  /** 销量目标类型 0 常规，1 单品，2 系列  枚举 GoalType*/
  @ApiModelProperty(value = "销量目标类型 0 常规，1 单品，2 系列 枚举 GoalType")
  private Integer saleGoalType;

  /** 销量目标类型 */
  @ApiModelProperty(value = "销量目标类型")
  private String saleGoalTypeName;

  /** 销量目标名称 */
  @ApiModelProperty(value = "销量目标名称")
  private String saleGoalName;

  /** 目标年份 */
  @ApiModelProperty(value = "目标年份")
  private Integer targetYear;

  /** 目标年份总量 */
  @ApiModelProperty(value = "目标年份总量")
  private BigDecimal targetNum;

  /** 目标年份总量字符串表现(不带小数点) */
  @ApiModelProperty(value = "目标年份总量字符串表现(不带小数点)")
  private String targetNumStr;

  /** 商品编码(类型是单品销售目标 该字段不能空) */
  @ApiModelProperty(value = "商品编码(类型是单品销售目标 该字段不能空)")
  private String productCode;

  /** 商品名称(类型是单品销售目标 该字段不能空) */
  @ApiModelProperty(value = "商品名称(类型是单品销售目标 该字段不能空)")
  private String productName;

  /** 商品规格(类型是单品销售目标 该字段不能空) */
  @ApiModelProperty(value = "商品规格(类型是单品销售目标 该字段不能空)")
  private String productSpec;

  /** 产品层级code(类型是非常规 该字段不能空) */
  @ApiModelProperty(value = "产品层级code(类型是非常规 该字段不能空)")
  private String productLevelCode;

  /** 产品层级名称(类型是非常规 该字段不能空) */
  @ApiModelProperty(value = "产品层级名称(类型是非常规 该字段不能空)")
  private String productLevelName;

  /** 对象维度，1 客户、2 组织、3 终端 */
  @ApiModelProperty(value = "对象维度，1 客户、2 组织、3 终端")
  private Integer objectType;

  /** 任务类型，1 年目标、2 季度目标、3 月度目标 */
  @ApiModelProperty(value = "任务类型，1 年目标、2 季度目标、3 月度目标")
  private Integer taskType;

  /** 组织编码（对象维度为组织时，选择） */
  @ApiModelProperty(value = "组织编码（对象维度为组织时，选择）")
  private String orgCode;

  /** 组织名称 */
  @ApiModelProperty(value = "组织名称")
  private String orgName;

  /** 终端编码（对象维度为终端时选择） */
  @ApiModelProperty(value = "终端编码（对象维度为终端时选择）")
  private String terminalCode;

  /** 终端名称 */
  @ApiModelProperty(value = "终端名称")
  private String terminalName;

  /** 合同编码 */
  @ApiModelProperty(value = "合同编码")
  private String contractCode;

  /** 唯一值 */
  @ApiModelProperty(value = "唯一值，去重时查询用 (类型是单品：产品code + 目标年份 ；类型是层级：产品层级code + 目标年份;类型是常规： 目标年份)")
  private String onlyKey;

  /** 详细信息 */
  @ApiModelProperty(value = "详细信息")
  private SaleGoalDetailDto saleGoalDetailDto;

  /** 数据检索编码 */
  @ApiModelProperty("数据检索编码")
  private String indexCode;

  /** 审批状态 */
  @ApiModelProperty("审批状态")
  private String sureState;

  /** 销量目标分摊 */
  @ApiModelProperty("销量目标分摊")
  private String sharingType = "none";

  /** 单位编码 */
  @ApiModelProperty("单位编码")
  private String unitCode;

  /** 对象编码 */
  @ApiModelProperty("对象编码")
  private String objectCode;

  /** 对象名称 */
  @ApiModelProperty("对象名称")
  private String objectName;

  /** 单位类型 0 元，1 万元，2 销售单位 3 基础单位 */
  @ApiModelProperty("单位类型 0 元，1 万元，2 销售单位 3 基础单位")
  private Integer unitType;

  /** 数据状态 0 正常，1 作废 */
  @ApiModelProperty("数据状态 0 正常，1 作废")
  private Integer dataState;
}
