package com.biz.crm.dms.business.sale.goal.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 销量目标类型
 * @author: rentao
 * @date: 2021/12/18 14:02
 */
public enum GoalType {

  /**
   * 常规
   * */
  ROUTINE(0,"0", "常规","1"),

  /**
   * 单品
   * */
  GOODS(1, "1","单品","2"),

  /**
   * 系列
   * */
  PRODUCT_LEVEL(2, "2","系列","3");


  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  GoalType(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 GoalType
   *
   * @param key
   * @return
   */
  public static GoalType getByKey(Integer key) {
    return Arrays.stream(GoalType.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
