package com.biz.crm.dms.business.sale.goal.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 对象维度
 * @author: rentao
 * @date: 2021/12/18 14:03
 */
public enum ObjectType {

  /**
   * 客户维度
   * */
  CUSTOMER(1,"1", "客户维度","1"),

  /**
   * 组织维度
   * */
  ORGANIZATION(2,"2", "组织维度","2"),

  /**
   * 终端维度
   * */
  TERMINAL(3,"3", "终端维度","3"),
  ;

  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ObjectType(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ObjectType
   *
   * @param key
   * @return
   */
  public static ObjectType getByKey(Integer key) {
    return Arrays.stream(ObjectType.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
