package com.biz.crm.dms.business.sale.goal.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 任务类型
 * @author: rentao
 * @date: 2021/12/18 14:03
 */
public enum TaskType {

  /**
   * 年度
   * */
  YEARLY(1,"1", "年度","1"),

  /**
   * 季度
   * */
  QUARTER(2, "2","季度","2"),

  /**
   * 月度
   * */
  MONTHLY(3, "3","月度","3"),
  ;

  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  TaskType(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 TaskType
   *
   * @param key
   * @return
   */
  public static TaskType getByKey(Integer key) {
    return Arrays.stream(TaskType.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }


}
