package com.biz.crm.dms.business.sale.goal.event;

import com.biz.crm.dms.business.sale.goal.vo.SaleGoalVo;
import java.util.List;

/**
 * @description: 销量目标事件通知接口
 * @author: rentao
 * @date: 2021/11/30 11:09
 */
public interface SaleGoalEventListener {


  /**
   * 当销量目标创建时触发
   *
   * @param vo 创建时的vo
   */
  void onCreate(SaleGoalVo vo);

  /**
   * 当销量目标修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(SaleGoalVo oldVo, SaleGoalVo newVo);

  /**
   * 当销量目标禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<SaleGoalVo> voList);

  /**
   * 当销量目标启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<SaleGoalVo> voList);

  /**
   * 当销量目标删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<SaleGoalVo> voList);
}
