package com.biz.crm.dms.business.sale.goal.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @description: 销量目标明细 vo
 * @author: rentao
 * @date: 2021/11/30 11:08
 */
@Data
@ApiModel(value = "销量目标明细vo")
public class SaleGoalDetailVo extends UuidFlagOpVo {

  /**
   * 销售目标id
   */
  @ApiModelProperty(value = "销售目标id")
  private String saleGoalId;

  /**
   * 一月目标销量
   */
  @ApiModelProperty(value = "一月目标销量")
  private BigDecimal janTargetNum;

  /**
   * 一月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "一月目标销量字符串表现(不带小数点)")
  private String janTargetNumStr;

  /**
   * 二月目标销量
   */
  @ApiModelProperty(value = "二月目标销量")
  private BigDecimal febTargetNum;

  /**
   * 二月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "二月目标销量字符串表现(不带小数点)")
  private String febTargetNumStr;

  /**
   * 三月目标销量
   */
  @ApiModelProperty(value = "三月目标销量")
  private BigDecimal marTargetNum;

  /**
   * 三月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "三月目标销量字符串表现(不带小数点)")
  private String marTargetNumStr;

  /**
   * 四月目标销量
   */
  @ApiModelProperty(value = "四月目标销量")
  private BigDecimal aprTargetNum;

  /**
   * 四月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "四月目标销量字符串表现(不带小数点)")
  private String aprTargetNumStr;

  /**
   * 五月目标销量
   */
  @ApiModelProperty(value = "五月目标销量")
  private BigDecimal mayTargetNum;

  /**
   * 五月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "五月目标销量字符串表现(不带小数点)")
  private String mayTargetNumStr;

  /**
   * 六月目标销量
   */
  @ApiModelProperty(value = "六月目标销量")
  private BigDecimal junTargetNum;

  /**
   * 六月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "六月目标销量字符串表现(不带小数点)")
  private String junTargetNumStr;

  /**
   * 七月目标销量
   */
  @ApiModelProperty(value = "七月目标销量")
  private BigDecimal julTargetNum;

  /**
   * 七月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "七月目标销量字符串表现(不带小数点)")
  private String julTargetNumStr;

  /**
   * 八月目标销量
   */
  @ApiModelProperty(value = "八月目标销量")
  private BigDecimal augTargetNum;

  /**
   * 八月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "八月目标销量字符串表现(不带小数点)")
  private String augTargetNumStr;

  /**
   * 九月目标销量
   */
  @ApiModelProperty(value = "九月目标销量")
  private BigDecimal sepTargetNum;

  /**
   * 九月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "九月目标销量字符串表现(不带小数点)")
  private String sepTargetNumStr;

  /**
   * 十月目标销量
   */
  @ApiModelProperty(value = "十月目标销量")
  private BigDecimal octTargetNum;

  /**
   * 十月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "十月目标销量字符串表现(不带小数点)")
  private String octTargetNumStr;

  /**
   * 十一月目标销量
   */
  @ApiModelProperty(value = "十一月目标销量")
  private BigDecimal novTargetNum;

  /**
   * 十一月目标销量
   */
  @ApiModelProperty(value = "十一月目标销量")
  private String novTargetNumStr;

  /**
   * 十二月目标销量
   */
  @ApiModelProperty(value = "十二月目标销量")
  private BigDecimal decTargetNum;

  /**
   * 十二月目标销量字符串表现(不带小数点)
   */
  @ApiModelProperty(value = "十二月目标销量字符串表现(不带小数点)")
  private String decTargetNumStr;

  /**
   * 第一季度目标销量
   */
  @ApiModelProperty(value = "第一季度目标销量")
  private BigDecimal firstQuarterNum;

  /**
   * 第二季度目标销量
   */
  @ApiModelProperty(value = "第二季度目标销量")
  private BigDecimal secondQuarterNum;

  /**
   * 第三季度目标销量
   */
  @ApiModelProperty(value = "第三季度目标销量")
  private BigDecimal thirdQuarterNum;

  /**
   * 第四季度目标销量
   */
  @ApiModelProperty(value = "第四季度目标销量")
  private BigDecimal fourthQuarterNum;

  /**
   * 年度目标销量
   */
  @ApiModelProperty(value = "年度目标销量")
  private BigDecimal yearlyNum;

  /**
   * 第一季度目标销量汇总
   */
  @ApiModelProperty(value = "第一季度目标销量汇总")
  private BigDecimal firstQuarterSum;

  /**
   * 第二季度目标销量汇总
   */
  @ApiModelProperty(value = "第二季度目标销量汇总")
  private BigDecimal secondQuarterSum;

  /**
   * 第三季度目标销量汇总
   */
  @ApiModelProperty(value = "第三季度目标销量汇总")
  private BigDecimal thirdQuarterSum;

  /**
   * 第四季度目标销量汇总
   */
  @ApiModelProperty(value = "第四季度目标销量汇总")
  private BigDecimal fourthQuarterSum;

  /**
   * 年度目标销量
   */
  @ApiModelProperty(value = "年度目标销量")
  private BigDecimal yearlySum;

  /**
   * 冗余字段：任务类型
   */
  @ApiModelProperty(value = "冗余字段：任务类型")
  private Integer taskType;
}
