package com.biz.crm.dms.business.sale.goal.vo.element;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @description: 常规销量目标
 * @author: rentao
 * @date: 2021/12/1 19:10
 */
@Data
@ApiModel(value = "常规销量目标要素vo")
public class SaleGoalRoutineDataVo {

  /**
   * 目标年份
   */
  @ApiModelProperty(value = "目标年份")
  private Integer targetYear;

  /**
   * 目标年份总量
   */
  @ApiModelProperty(value = "目标年份总量")
  private BigDecimal targetNum;


  /**
   * 一月目标销量
   */
  @ApiModelProperty(name = "janTargetNum", value = "一月目标销量", required = true)
  private BigDecimal janTargetNum;

  /**
   * 二月目标销量
   */
  @ApiModelProperty(name = "janTargetNum", value = "二月目标销量", required = true)
  private BigDecimal febTargetNum;

  /**
   * 三月目标销量
   */
  @ApiModelProperty(name = "marTargetNum", value = "三月目标销量", required = true)
  private BigDecimal marTargetNum;

  /**
   * 四月目标销量
   */
  @ApiModelProperty(name = "aprTargetNum", value = "四月目标销量", required = true)
  private BigDecimal aprTargetNum;

  /**
   * 五月目标销量
   */
  @ApiModelProperty(name = "mayTargetNum", value = "五月目标销量", required = true)
  private BigDecimal mayTargetNum;

  /**
   * 六月目标销量
   */
  @ApiModelProperty(name = "junTargetNum", value = "六月目标销量", required = true)
  private BigDecimal junTargetNum;

  /**
   * 七月目标销量
   */
  @ApiModelProperty(name = "junTargetNum", value = "七月目标销量", required = true)
  private BigDecimal julTargetNum;

  /**
   * 八月目标销量
   */
  @ApiModelProperty(name = "augTargetNum", value = "八月目标销量", required = true)
  private BigDecimal augTargetNum;

  /**
   * 九月目标销量
   */
  @ApiModelProperty(name = "sepTargetNum", value = "九月目标销量", required = true)
  private BigDecimal sepTargetNum;

  /**
   * 十月目标销量
   */
  @ApiModelProperty(name = "octTargetNum", value = "十月目标销量", required = true)
  private BigDecimal octTargetNum;

  /**
   * 十一月目标销量
   */
  @ApiModelProperty(name = "novTargetNum", value = "十一月目标销量", required = true)
  private BigDecimal novTargetNum;

  /**
   * 十二月目标销量
   */
  @ApiModelProperty(name = "decTargetNum", value = "十二月目标销量", required = true)
  private BigDecimal decTargetNum;

  /**
   * 第一季度目标销量
   */
  @ApiModelProperty(name = "firstQuarterNum", value = "第一季度目标销量", required = true)
  private BigDecimal firstQuarterNum;

  /**
   * 第二季度目标销量
   */
  @ApiModelProperty(name = "secondQuarterNum", value = "第二季度目标销量", required = true)
  private BigDecimal secondQuarterNum;

  /**
   * 第三季度目标销量
   */
  @ApiModelProperty(name = "thirdQuarterNum", value = "第三季度目标销量", required = true)
  private BigDecimal thirdQuarterNum;

  /**
   * 第四季度目标销量
   */
  @ApiModelProperty(name = "fourthQuarterNum", value = "第四季度目标销量", required = true)
  private BigDecimal fourthQuarterNum;

  /**
   * 年度目标销量
   */
  @ApiModelProperty(name = "yearlyNum", value = "年度目标销量", required = true)
  private BigDecimal yearlyNum;

  /**
   * 第一季度目标销量汇总
   */
  @ApiModelProperty(name = "firstQuarterSum", value = "第一季度目标销量汇总", required = true)
  private BigDecimal firstQuarterSum;

  /**
   * 第二季度目标销量汇总
   */
  @ApiModelProperty(name = "secondQuarterSum", value = "第二季度目标销量汇总", required = true)
  private BigDecimal secondQuarterSum;

  /**
   * 第三季度目标销量汇总
   */
  @ApiModelProperty(name = "thirdQuarterSum", value = "第三季度目标销量汇总", required = true)
  private BigDecimal thirdQuarterSum;

  /**
   * 第四季度目标销量汇总
   */
  @ApiModelProperty(name = "fourthQuarterSum", value = "第四季度目标销量汇总", required = true)
  private BigDecimal fourthQuarterSum;

  /**
   * 年度目标销量
   */
  @ApiModelProperty(name = "yearlySum", value = "年度目标销量", required = true)
  private BigDecimal yearlySum;

  /**
   * 冗余字段 唯一键
   * */
  @ApiModelProperty(name = "onlyKey", value = "唯一键", required = true)
  private String onlyKey;

  /**
   * 合同编码
   * */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  private String contractCode;

}
