package com.biz.crm.dms.business.sale.goal.vo.element;

import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractElementDataVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @description: 常规销量目标要素 vo
 * @author: rentao
 * @date: 2021/12/1 19:09
 */
@ApiModel("常规销量目标要素")
@Data
public class SaleGoalRoutineElementDataVo extends ContractElementDataVo {

  /**
   * 经销商编码
   * */
  @ApiModelProperty("经销商编码")
  private String cusCode;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  private String contractCode;

  /**
   * 任务类型，1 年目标、2 季度目标、3 月度目标
   * */
  @ApiModelProperty("任务类型，1 年目标、2 季度目标、3 月度目标")
  private Integer taskType;

  /**
   * 销量目标名称
   */
  @ApiModelProperty(name = "saleGoalName", value = "销量目标名称", required = true)
  private String saleGoalName;

  /**
   * 单位类型
   */
  @ApiModelProperty(name = "unitType", value = "单位类型", required = true)
  private Integer unitType;

  /**
   * 目标类型 0 常规，1 单品，2 系列
   *
   */
  @ApiModelProperty(name = "saleGoalType", value = "目标类型 0 常规，1 单品，2 系列", required = true)
  private Integer saleGoalType;

  /**
   * 常规销量目标集合
   * */
  @ApiModelProperty("常规销量目标")
  private List<SaleGoalRoutineDataVo> dataVos;
}
