package com.biz.crm.dms.business.stock.customer.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.stock.customer.feign.feign.internal.StockStatisticsVoServiceFeignImpl;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月29日 17:58:00
 */
@FeignClient(
    name = "${dms.feign-client.name:crm-dms}",
    path = "crm-dms",
    fallbackFactory = StockStatisticsVoServiceFeignImpl.class)
public interface StockStatisticsVoServiceFeign {

  @PostMapping("/v1/stockStatistics/stockStatistics")
  Result<?> create(@ApiParam(name = "StockStatisticsVo", value = "库存提报明细子表") @RequestBody List<StockStatisticsDto> stockStatisticsVos);
}
