package com.biz.crm.dms.business.stock.customer.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.stock.customer.feign.feign.StockStatisticsVoServiceFeign;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月29日 18:00:00
 */
@Service
@Slf4j
public class StockStatisticsVoServiceFeignImpl implements FallbackFactory<StockStatisticsVoServiceFeign> {

  @Override
  public StockStatisticsVoServiceFeign create(Throwable cause) {
    log.error("进入StockStatisticsVoServiceFeignImpl熔断", cause);
    return new StockStatisticsVoServiceFeign() {
      @Override
      public Result<?> create(List<StockStatisticsDto> stockStatisticsVos) {
        throw new UnsupportedOperationException("库存提报熔断");
      }
    };
  }
}
