package com.biz.crm.dms.business.stock.customer.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 库存提报主表(StockStatistics)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:15:59
 */
@RestController
@RequestMapping("/v1/stockStatistics/stockStatistics")
@Slf4j
@Api(tags = "库存提报主表:StockStatistics:库存提报主表")
public class StockStatisticsController {
  /**
   * 服务对象
   */
  @Autowired
  private StockStatisticsService stockStatisticsService;

  /**
   * 分页查询所有数据
   *
   * @param pageable        分页对象
   * @param stockStatistics 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<StockStatistics>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "stockStatistics", value = "库存提报主表") StockStatisticsPageDto stockStatistics) {
    try {
      Page<StockStatistics> page = this.stockStatisticsService.findByConditions(pageable, stockStatistics);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
