package com.biz.crm.dms.business.stock.customer.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import com.biz.crm.dms.business.stock.customer.sdk.service.StockStatisticsDetailVoService;
import com.biz.crm.dms.business.stock.customer.sdk.vo.StockStatisticsDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:库存提报明细子表 Vo
 * @createTime 2022年07月28日 15:23:00
 */
@RestController
@RequestMapping("/v1/stockStatisticsDetail/stockStatisticsDetail")
@Slf4j
@Api(tags = "库存提报明细子表:StockStatisticsDetailVo:库存提报明细子表")
public class StockStatisticsDetailVoController {


  @Autowired
  private StockStatisticsDetailVoService stockStatisticsDetailVoService;

  @ApiOperation(value = "查询明细")
  @GetMapping("/findDetailByConditions")
  public Result< List<StockStatisticsDetailVo> > findDetailByConditions(StockStatisticsDetailDto dto) {
    try {
      List<StockStatisticsDetailVo>  res = this.stockStatisticsDetailVoService.findDetailByConditions(dto);
      return Result.ok(res);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
