package com.biz.crm.dms.business.stock.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.service.StockStatisticsVoService;
import com.biz.crm.dms.business.stock.customer.sdk.vo.StockStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月26日 16:10:00
 */
@RestController
@RequestMapping("/v1/stockStatistics/stockStatistics")
@Slf4j
@Api(tags = "库存提报Dto:StockStatisticsVo:库存提报Dto")
public class StockStatisticsVoController {

  @Autowired
  private StockStatisticsVoService stockStatisticsVoService;

  /**
   * 新增数据(库存提报)
   *
   * @param stockStatisticsVos 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "库存提报")
  @PostMapping
  public Result<?> create(@ApiParam(name = "StockStatisticsVo", value = "库存提报明细子表") @RequestBody List<StockStatisticsDto> stockStatisticsVos) {
    try {
      this.stockStatisticsVoService.create(stockStatisticsVos);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "库存提报界面查询")
  @GetMapping("/findDetailByCusCode")
  public Result<List<StockStatisticsVo>> findDetailByCusCode(@ApiParam(name = "stockStatistics", value = "库存提报主表") StockStatisticsDto dto) {
    try {
      List<StockStatisticsVo> res = this.stockStatisticsVoService.findDetailByCusCode(dto);
      return Result.ok(res);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 库存提报界面查询分页查询
   *
   * @param dto 参数dto
   * @return 库存提报分页数据
   */
  @ApiOperation(value = "库存提报界面查询分页查询")
  @GetMapping("/findByStockStatisticsDto")
  public Result<Page<StockStatisticsVo>> findByStockStatisticsDto(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "stockStatistics", value = "库存提报主表") StockStatisticsDto dto) {
    try {
      return Result.ok(this.stockStatisticsVoService.findByStockStatisticsDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
