package com.biz.crm.dms.business.stock.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe:库存提报明细子表实体
 * @createTime 2022年07月25日 16:41:00
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StockStatisticsDetail", description = "库存提报明细子表")
@Entity
@TableName("dms_stock_statistics_detail")
@Table(name = "dms_stock_statistics_detail",
    indexes = {@Index(columnList = "cus_code,product_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_stock_statistics_detail", comment = "库存提报明细子表")
public class StockStatisticsDetail extends UuidFlagOpEntity {

  private static final long serialVersionUID = -5748572757630240963L;


  /**
   * 操作来源
   */
  @ApiModelProperty(name = "OperationSource", value = "操作来源", required = true)
  @Column(name = "operation_source", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '操作来源'")
  private String operationSource;

  /**
   * 操作类型
   */
  @ApiModelProperty(name = "OperationType", value = "操作类型", required = true)
  @Column(name = "operation_type", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '操作类型'")
  private String operationType;

  /**
   * 调整类型
   */
  @ApiModelProperty(name = "adjustType", value = "调整类型", required = true)
  @Column(name = "adjust_type", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '调整类型'")
  private String adjustType;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  @Column(name = "cus_code", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '客户编码'")
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  @Column(name = "cus_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户名称'")
  private String cusName;

  /**
   * 商品编码
   */
  @ApiModelProperty(name = "productCode", value = "商品编码", required = true)
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '商品编码'")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty(name = "productName", value = "商品名称", required = true)
  @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品名称'")
  private String productName;

  /**
   * 商品单位
   */
  @ApiModelProperty(name = "productUnit", value = "商品单位", required = true)
  @Column(name = "product_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品单位 '")
  private String productUnit;

  /**
   * 操作数量
   */
  @ApiModelProperty(name = "operationQuantity", value = "操作数量", required = true)
  @Column(name = "operation_quantity", length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 操作数量 '")
  private BigDecimal operationQuantity;

  /**
   * 操作后数量
   */
  @ApiModelProperty(name = "quantity", value = "操作后数量", required = true)
  @Column(name = "quantity", length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 操作后数量 '")
  private BigDecimal quantity;

  /**
   * 关联单据编码
   */
  @ApiModelProperty(name = "orderCode", value = "关联单据编码", required = true)
  @Column(name = "order_code", length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 关联单据编码 '")
  private String orderCode;

  /**
   * 操作人（创建人）所属组织编码
   */
  @ApiModelProperty(name = "cusOrgCode", value = "操作人（创建人）所属组织编码", required = true)
  @Column(name = "operation_org_code", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '操作人（创建人）所属组织编码'")
  private String operationOrgCode;

  /**
   * 操作人（创建人）所属组织名称
   */
  @ApiModelProperty(name = "cusOrgName", value = "操作人（创建人）所属组织名称", required = true)
  @Column(name = "operation_org_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '操作人（创建人）所属组织名称'")
  private String operationOrgName;

  /**
   * 操作人（创建人）职位编码
   */
  @ApiModelProperty(name = "operationPositionCode", value = "操作人（创建人）职位编码", required = true)
  @Column(name = "operation_position_code", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '操作人（创建人）职位编码'")
  private String operationPositionCode;

  /**
   * 操作人（创建人）职位名称
   */
  @ApiModelProperty(name = "operationPositionName", value = "操作人（创建人）职位名称", required = true)
  @Column(name = "operation_position_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '操作人（创建人）职位名称'")
  private String operationPositionName;


  /**
   * 操作时间（当前时间因要与主表保持一致，故不使用创建时间）
   */
  @ApiModelProperty(name = "operationTime", value = "操作时间", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "operation_time", length = 20, columnDefinition = "datetime COMMENT '操作时间'")
  private Date operationTime;
}
