package com.biz.crm.dms.business.stock.customer.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.local.mapper.StockStatisticsMapper;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 库存提报主表(StockStatistics)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:15:59
 */
@Component
public class StockStatisticsRepository extends ServiceImpl<StockStatisticsMapper, StockStatistics> {

  @Autowired
  private StockStatisticsMapper stockStatisticsMapper;
  
   /**
   * 分页查询数据
    *
   * @param pageable 分页对象
   * @param dto 参数dto
   * @return 分页数据
   */
  public Page<StockStatistics> findByConditions(Pageable pageable, StockStatisticsPageDto dto) {
    Page<StockStatistics> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return stockStatisticsMapper.findByConditions(page, dto);
  }

  public StockStatistics findByCusCodeAndProductCode(String cusCode, String productCode) {
  return this.lambdaQuery()
      .eq(StockStatistics::getCusCode,cusCode)
      .eq(StockStatistics::getProductCode,productCode)
      .eq(StockStatistics::getTenantCode, TenantUtils.getTenantCode())
      .one();
  }

  /**
   * 通过客户编码查询
   * @param cusCode
   * @return
   */
  public List<StockStatistics> findByCusCode(String cusCode) {
    return this.lambdaQuery()
        .eq(StockStatistics::getCusCode,cusCode)
        .eq(StockStatistics::getTenantCode, TenantUtils.getTenantCode())
        .list();
  }
}

